//
//  AccelerometerExampleViewController.m
//  AccelerometerExample
//
//  Created by Brad Larson on 3/21/2010.
//

#import "AccelerometerExampleViewController.h"

@implementation AccelerometerExampleViewController

#pragma mark -
#pragma mark Initialization and teardown

- (void)viewDidLoad 
{
    [super viewDidLoad];
	
	previousLowPassFilteredXAcceleration = 0.0;
	previousLowPassFilteredYAcceleration = 0.0;
	previousLowPassFilteredZAcceleration = 0.0;
	previousHighPassFilteredXAcceleration = 0.0;
	previousHighPassFilteredYAcceleration = 0.0;
	previousHighPassFilteredZAcceleration = 0.0;
	
	UIAccelerometer*  theAccelerometer = [UIAccelerometer sharedAccelerometer];
    theAccelerometer.updateInterval = 1.0 / 50.0;
 
    theAccelerometer.delegate = self;
}

- (void)didReceiveMemoryWarning 
{
    [super didReceiveMemoryWarning];
}

- (void)dealloc 
{
	UIAccelerometer*  theAccelerometer = [UIAccelerometer sharedAccelerometer];
    theAccelerometer.delegate = nil;
	
    [super dealloc];
}

#pragma mark -
#pragma mark UIAccelerometerDelegate method

#define kLowPassFilteringFactor 0.1
#define kHighPassFilteringFactor 0.1

- (void)accelerometer:(UIAccelerometer *)accelerometer didAccelerate:(UIAcceleration *)acceleration
{
    UIAccelerationValue currentXAcceleration, currentYAcceleration, currentZAcceleration;
    currentXAcceleration = acceleration.x;
    currentYAcceleration = acceleration.y;
    currentZAcceleration = acceleration.z;
	
    // Display the raw values

	xAccelerationLabel.text = [NSString stringWithFormat:@"%.3f", currentXAcceleration];
	yAccelerationLabel.text = [NSString stringWithFormat:@"%.3f", currentYAcceleration];
	zAccelerationLabel.text = [NSString stringWithFormat:@"%.3f", currentZAcceleration];
 
	// Do low-pass filtering of the values
	
	UIAccelerationValue lowPassFilteredXAcceleration = (currentXAcceleration * kLowPassFilteringFactor) + (previousLowPassFilteredXAcceleration * (1.0 - kLowPassFilteringFactor));
    UIAccelerationValue lowPassFilteredYAcceleration = (currentYAcceleration * kLowPassFilteringFactor) + (previousLowPassFilteredYAcceleration * (1.0 - kLowPassFilteringFactor));
	UIAccelerationValue lowPassFilteredZAcceleration = (currentZAcceleration * kLowPassFilteringFactor) + (previousLowPassFilteredZAcceleration * (1.0 - kLowPassFilteringFactor));
	
	lowPassXAccelerationLabel.text = [NSString stringWithFormat:@"%.3f", lowPassFilteredXAcceleration];
	lowPassYAccelerationLabel.text = [NSString stringWithFormat:@"%.3f", lowPassFilteredYAcceleration];
	lowPassZAccelerationLabel.text = [NSString stringWithFormat:@"%.3f", lowPassFilteredZAcceleration];
	
	previousLowPassFilteredXAcceleration = lowPassFilteredXAcceleration;
	previousLowPassFilteredYAcceleration = lowPassFilteredYAcceleration;
	previousLowPassFilteredZAcceleration = lowPassFilteredZAcceleration;
	
	// Do high-pass filtering of the values	

//	UIAccelerationValue highPassFilteredXAcceleration = currentXAcceleration - ( (currentXAcceleration * kHighPassFilteringFactor) + (previousHighPassFilteredXAcceleration * (1.0 - kHighPassFilteringFactor)) );
//    UIAccelerationValue highPassFilteredYAcceleration = currentYAcceleration - ( (currentYAcceleration * kHighPassFilteringFactor) + (previousHighPassFilteredYAcceleration * (1.0 - kHighPassFilteringFactor)) );
//    UIAccelerationValue highPassFilteredZAcceleration = currentZAcceleration - ( (currentZAcceleration * kHighPassFilteringFactor) + (previousHighPassFilteredZAcceleration * (1.0 - kHighPassFilteringFactor)) );

	UIAccelerationValue highPassFilteredXAcceleration = currentXAcceleration - lowPassFilteredXAcceleration;
    UIAccelerationValue highPassFilteredYAcceleration = currentYAcceleration - lowPassFilteredYAcceleration;
    UIAccelerationValue highPassFilteredZAcceleration = currentZAcceleration - lowPassFilteredZAcceleration;
	
	highPassXAccelerationLabel.text = [NSString stringWithFormat:@"%.3f", highPassFilteredXAcceleration];
	highPassYAccelerationLabel.text = [NSString stringWithFormat:@"%.3f", highPassFilteredYAcceleration];
	highPassZAccelerationLabel.text = [NSString stringWithFormat:@"%.3f", highPassFilteredZAcceleration];
	
	previousHighPassFilteredXAcceleration = highPassFilteredXAcceleration;
	previousHighPassFilteredYAcceleration = highPassFilteredYAcceleration;
	previousHighPassFilteredZAcceleration = highPassFilteredZAcceleration;
}

@end
