//
//  SimpleCoreDataAppDelegate.m
//  SimpleCoreData
//
//  Created by Brad Larson on 2/23/2010.
//

#import "SimpleCoreDataAppDelegate.h"
#import "RootViewController.h"
#import "MATCDatabaseController.h"

@implementation SimpleCoreDataAppDelegate

@synthesize window;
@synthesize navigationController;

#pragma mark -
#pragma mark Initialization and teardown

- (void)dealloc 
{
	[navigationController release];
	[window release];
	[super dealloc];
}

#pragma mark -
#pragma mark Application lifecycle

- (void)applicationDidFinishLaunching:(UIApplication *)application {    
    
	// Set up the shake-to-undo
	application.applicationSupportsShakeToEdit = YES;

    // Override point for customization after app launch    

	RootViewController *rootViewController = (RootViewController *)[navigationController topViewController];
	rootViewController.managedObjectContext = [[MATCDatabaseController sharedDatabaseController] managedObjectContext];
	
	[window addSubview:[navigationController view]];
    [window makeKeyAndVisible];
}

/**
 applicationWillTerminate: saves changes in the application's managed object context before the application terminates.
 */
- (void)applicationWillTerminate:(UIApplication *)application 
{
	[[MATCDatabaseController sharedDatabaseController] saveChangesToDatabase];
}

@end

