//
//  SLSScrollAreaController.m
//  ZoomingScrollView
//
//  Created by Brad Larson on 2/20/2009.
//

#import "SLSScrollAreaController.h"
#import "SLSScrollView.h"
#import "SLSZoomableView.h"
#import <QuartzCore/QuartzCore.h>

@implementation SLSScrollAreaController

#pragma mark -
#pragma mark Initialization and teardown

/*
// The designated initializer. Override to perform setup that is required before the view is loaded.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if (self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil]) {
        // Custom initialization
    }
    return self;
}
*/


// Implement loadView to create a view hierarchy programmatically, without using a nib.
- (void)loadView 
{
//	UIView *primaryView = [[UIView alloc] initWithFrame:CGRectMake(0.0f, 0.0f, 320.0f, 480.0f)];
	UIView *primaryView = [[UIView alloc] initWithFrame:[[UIScreen mainScreen] applicationFrame]];

	scrollView = [[SLSScrollView alloc] initWithFrame:CGRectMake(0.0f, 0.0f, primaryView.frame.size.width, primaryView.frame.size.height)];
	scrollView.bounces = YES;
	scrollView.bouncesZoom = NO;
	scrollView.scrollEnabled = YES;
	scrollView.minimumZoomScale = 1.0;
	scrollView.maximumZoomScale = 25.0;
	//	scrollView.indicatorStyle = UIScrollViewIndicatorStyleWhite;
	scrollView.delegate = self;
	
	[primaryView addSubview:scrollView];
	
	zoomableView = [[SLSZoomableView alloc] initWithFrame:CGRectZero];
	zoomableView.contentInset = UIEdgeInsetsMake(10.0f, 10.0f, 10.0f, 10.0f);
	zoomableView.sizeToCenterContentIn = CGSizeMake(320.0f, 460.0f);
	zoomableView.text = @"Test";
	[scrollView addSubview:zoomableView];	
	
//	CGRect scrollViewFrame = scrollView.frame;
	
//	float horizontalInsets = MAX(round((scrollViewFrame.size.height / 2.0f) - (zoomableView.frame.size.height / 2.0f)), 0.0f);
//	float verticalInsets = MAX(round((scrollViewFrame.size.width / 2.0f) - (zoomableView.frame.size.width / 2.0f)), 0.0f);
	
	
	scrollView.contentInset = UIEdgeInsetsZero;
	
//	UIEdgeInsetsMake(verticalInsets, horizontalInsets, verticalInsets, horizontalInsets);
	scrollView.contentSize = zoomableView.frame.size;

	self.view = primaryView;
	[primaryView release];
}

- (void)didReceiveMemoryWarning 
{
    [super didReceiveMemoryWarning]; // Releases the view if it doesn't have a superview
    // Release anything that's not essential, such as cached data
}


- (void)dealloc {
    [super dealloc];
}


#pragma mark -
#pragma mark UIScrollViewDelegate methods

- (UIView *)viewForZoomingInScrollView:(UIScrollView *)theScrollView;
{
	NSLog(@"Content offset at start: %@", NSStringFromCGPoint(scrollView.contentOffset));
	return zoomableView;
}

- (void)scrollViewDidEndZooming:(UIScrollView *)theScrollView withView:(UIView *)view atScale:(float)scale;
{	
	CGPoint currentOffset = scrollView.contentOffset;
	[CATransaction begin];
	[CATransaction setValue:(id)kCFBooleanTrue
					 forKey:kCATransactionDisableActions];
#ifdef DOSHARPZOOMING
	[zoomableView setTransformWithoutScaling:CGAffineTransformIdentity];
	zoomableView.currentScale = scale;
	CGPoint newContentOffset = [zoomableView convertedContentOffsetFromPreviousScale:currentOffset];	
	zoomableView.previousScale = scale;

	scrollView.contentOffset = newContentOffset;
	scrollView.shouldSuppressLayout = YES;
	scrollView.contentSize = zoomableView.frame.size;
	scrollView.shouldSuppressLayout = NO;
#endif
	

	[CATransaction commit];
	[scrollView flashScrollIndicators];
}


@end
