//
//  SLSZoomableView.h
//  ZoomingScrollView
//
//  Created by Brad Larson on 2/21/2009.
//

#import <UIKit/UIKit.h>

#define DOSHARPZOOMING 1

@interface SLSZoomableView : UIView 
{
	float previousScale, currentScale;
	UIEdgeInsets contentInset, scrollOffsetCorrection;
	NSString *text;
	CGRect drawableArea;
	CGSize previousSideOffsets;
	CGSize sizeToCenterContentIn;
}

@property(readwrite, nonatomic) float previousScale, currentScale;
@property(readwrite, copy, nonatomic) NSString *text;
@property(readwrite, nonatomic) UIEdgeInsets contentInset;
@property(readwrite, nonatomic) CGSize sizeToCenterContentIn;

// Helper methods
- (CGPoint)convertedContentOffsetFromPreviousScale:(CGPoint)contentOffset;

// Accessors
- (void)setTransformWithoutScaling:(CGAffineTransform)newTransform;

@end
